class RedPhotonBlast extends PhotonBlast;

var name damageType;			// type of damage that this projectile does
var float	mpBlastRadius;
var() bool           bDamaged;         // was this blown up via damage?

simulated function DrawExplosionEffects(vector HitLocation, vector HitNormal)
{
	local ExplosionLight light;
	local int i;
	local Rotator rot;
	local RFCEffect sphere;
   local ExplosionSmall expeffect;

	// draw a pretty explosion
	light = Spawn(None,,, HitLocation);
	if (light != None)
	{
      if (!bDamaged)
         light.RemoteRole = ROLE_None;
		light.size = 8;
		light.LightHue = 128;
		light.LightSaturation = 96;
		light.LightEffect = LE_Shell;
	}

	expeffect = Spawn(None,,, HitLocation);
   if ((expeffect != None) && (!bDamaged))
      expeffect.RemoteRole = ROLE_None;

	// draw a cool light sphere
	sphere = Spawn(class'Markistan.RFCEffect',,, HitLocation);
	if (sphere != None)
   {
      if (!bDamaged)
         sphere.RemoteRole = ROLE_None;
		sphere.size = blastRadius / 32.0;
   }
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( Level.NetMode != NM_Standalone )
	{
		blastRadius=mpBlastRadius;
		bIgnoresNanoDefense=True;
	}
}

function Tick(float Deltatime)
{
}

defaultproperties
{
     DamageType=Disintegrated
     mpBlastRadius=128.000000
     bExplodes=True
     blastRadius=128.000000
     ItemName="Red Photon Blast"
     Damage=125.000000
     ImpactSound=Sound'DeusExSounds.Weapons.LAMExplode'
     ExplosionDecal=Class'Markistan.PhotonMarkRed'
     Skin=FireTexture'Effects.Laser.LaserSpot1'
     DrawScale=2.500000
     SoundRadius=128
     SoundVolume=50
     LightSaturation=50
     LightBrightness=12.5
     LightRadius=25
}
